#include <sys/io.h>
#include <stdio.h>
#include <stdlib.h>
#include <curses.h>
#include <semaphore.h>
#include <pthread.h>
#include <unistd.h>
#include <time.h>
#include <uuid/uuid.h>
#include "can.h"
#include "errcode.h"



/* For User Interface */
#define SUB_LINES_LEFT_1 7 
int running = 0;

sem_t plotting;
int   baseLine = 0;

WINDOW *subWinLeft1  = NULL;
WINDOW *subWinLeft2  = NULL;
WINDOW *subWinRight = NULL;

static void* getCanPkg(void *);
static void* inputCmd(void *);
static void* scanStatus(void *);

static void showWinText(WINDOW *win, int lines, int cols, char *str);
static void clearLine(WINDOW *win, int lines, int cols);
static void printLeftText(void);

/* End */

/* For CAN bus operations */
int pkgNum = 10;
int baud = 125;
int pkgLength = 8;

canmsg_t samplePkg;
canmsg_t pkgHead;


uuid_t randBytes;

/* End */
int main(void)
{
  int subLinesLeft1 = 0;
  int subLinesLeft2 = 0;
  int subLinesRight = 0;
  int subColsLeft   = 0;
  int subColsRight  = 0;

  pthread_t scanningRegThd;
  pthread_t inputingCmdThd;
	pthread_t scanningStatusThd;


  initscr();

  /*
   * Start colors
   */
  if( !has_colors() ) {
    fprintf(stderr, "No color support");
    exit(1);
  }
  
  if( start_color() != OK ) {
    fprintf( stderr, "Start color fail");
    exit(1);
  }

/*
 *        -----------------------------
 *        |                  |        |
 *        |   subWinLeft1    |        |
 *        |                  |        |
 *        -------------------|        |
 *        |                  |        |
 *        |                  | subWin |
 *        |                  | Right  |
 *        |                  |        |
 *        |    subWinLeft2   |        |
 *        |                  |        |
 *        |                  |        |
 *        |                  |        |
 *        |                  |        |
 *        -----------------------------
 *
 */
  subLinesLeft1  = SUB_LINES_LEFT_1;
  subLinesLeft2  = LINES -2 -3 -2 - subLinesLeft1;
  subLinesRight  = LINES - 4;

  subColsLeft    = (COLS - 2 -3 -2 )*2 / 3;
  subColsRight   = (COLS - 2 -3 -2 ) / 3;


  subWinLeft1 = newwin( subLinesLeft1, subColsLeft, 2, 2);
  scrollok( subWinLeft1, 1);

  subWinLeft2 = newwin( subLinesLeft2, subColsLeft, 2+subLinesLeft1+3, 2);
  scrollok( subWinLeft2, 1);

  subWinRight = newwin( subLinesRight, subColsRight, 2, 2+subColsLeft+3);
  scrollok( subWinRight, 1);

  init_pair(3, COLOR_BLACK, COLOR_YELLOW );  
  init_pair(70, COLOR_WHITE,  COLOR_BLACK);

  wattrset( stdscr, COLOR_PAIR(3) );

  /* Plot Frame */
  move(0, 0);
  hline(' ', COLS); // Top herizon
  move(LINES-1, 0);
  hline(' ', COLS); // Bottom herizon

  move(1, 0); // left 
  vline(' ', LINES-2);
  move(1, 2+subColsLeft+1); // middle
  vline(' ', LINES-2);
  move(1, COLS-1); // right
  vline(' ', LINES-2);

  move(2+subLinesLeft1+1, 1);
  hline(' ', 1+subColsLeft+1); 

  refresh();

  wattrset( stdscr, COLOR_PAIR(70) );
  /* End */

  sem_init(&plotting, 0, 1);
  /* Print out the main items at the left window. */
  printLeftText();


  running = 1;
  pthread_create(&scanningRegThd, NULL, getCanPkg, NULL );
  pthread_create(&scanningStatusThd, NULL, scanStatus, NULL );
  pthread_create(&inputingCmdThd, NULL, inputCmd, NULL );

  pthread_join( inputingCmdThd, NULL );
	pthread_join( scanningStatusThd, NULL );
  //pthread_join( scanningRegThd, NULL );

  sem_destroy( &plotting );

  delwin(subWinRight);
  delwin(subWinLeft2);
  delwin(subWinLeft1);

  endwin();

  exit(0);
}

void *inputCmd(void *ptr)
{
  char num = 0;
  int result = -1;
  int i;
	int tempBaud = 0;

	samplePkg.length=8;
	for(i=0; i<8; i++)
		samplePkg.data[i] = i;

  while( running )
  {

    wscanw(subWinLeft2, "%d", &num);
		sem_wait(&plotting);
    wrefresh(subWinLeft2);
		sem_post(&plotting);

    if( num != 0 ) {

      if( num < -1 || num > 5 ) {
        showWinText(subWinLeft2, baseLine+2, 0, "Wrong number!");
        sleep(1);
        werase(subWinLeft2);
				wrefresh(subWinLeft2);
        printLeftText();

        continue;
      }

      switch( num ) {
        case 1:
            /* ---- switch(num) case 1 ---- */
						/* Set the number of packages to send. */
						showWinText(subWinLeft2, baseLine+2, 0, "The number of packages: ");

						wscanw(subWinLeft2, "%d", &pkgNum);
						sem_wait(&plotting);
                                                wrefresh(subWinLeft2);

						werase(subWinLeft2);
						sem_post(&plotting);
						printLeftText();
						num=100;

            break;
  
        case 2:
            /* ---- switch(num) case 2 ---- */
						if(pkgNum==0) {
						  while(1)
                                                    sendCanMessages(&samplePkg, 1);
                                                } else {
						for(i=0; i< pkgNum; i++)
							sendCanMessages( &samplePkg, 1);
                                                }

						werase(subWinLeft2);
						printLeftText();
						num=100;

            break;

        case 3:
            /* ---- switch(num) case 3 ---- */
						showWinText(subWinLeft2, baseLine+4, 0, \
						"Supported Baud rates:\n\t10, 20, 50, 100, 125, 250, 500, \
800, 1000");
						showWinText(subWinLeft2, baseLine+2, 0, "Input the Baud rate: ");

						wscanw(subWinLeft2, "%d", &tempBaud);
				    wrefresh(subWinLeft2);
				
						result = -1;
						result = configCan(tempBaud);
						if( result == ERRMSG( ERROR_API_CANCONFIG, ERROR_GEN_INPUT_DATA ) ) {
							showWinText(subWinLeft2, baseLine+7, 0, "Wrong Baud rate!!!\n");
							sleep(1);

							werase(subWinLeft2);
							printLeftText();

							break;
						}

						if( result == ERROR_GEN_DEVICE_FAIL ) {
							showWinText(subWinLeft2, baseLine+7, 0, "Fail to set Baud rate!!!\n");
							sleep(1);

							werase(subWinLeft2);
							printLeftText();

							break;
						}

						baud = tempBaud;

						werase(subWinLeft2);
						printLeftText();
						
						break;

			case 4:
						sem_wait(&plotting);

						werase(subWinRight);
						wrefresh(subWinRight);

						werase(subWinLeft2);
						wrefresh(subWinLeft2);

						sem_post(&plotting);

						printLeftText();

						break;

			case 5:
						sem_wait(&plotting);

						werase(subWinLeft2);
						wrefresh(subWinLeft2);

						sem_post(&plotting);

						printLeftText();

						break;


        default:
          break;

      } // End of switch()

    } else {
      running = 0;
    } // End of 'if( num != 0 )'
  }

  pthread_exit(NULL);
}

void *getCanPkg(void *ptr)
{
  unsigned int result = -1;
	unsigned int id = 1;

  while( running )
  {
		//struct canmsg_t pkg = {0};
		canmsg_t pkg = { .flags = 0 };


    //werase( subWinRight );

    /* Ignition Status */
    result = getCanMessages( &pkg, 1);
    sem_wait(&plotting);
		if( result != ERROR_API_SUCC ) {
	    if( result == ERROR_API_CANGETMESSAGES )
				wprintw(subWinRight, "Get CAN message error!!!\n");

			if( result == ERROR_API_CAN_OPEN_FAIL )
				wprintw(subWinRight, "Open CAN device fail!!!\n");
    }

		wprintw( subWinRight, "ID=%5d \n", id);
		wprintw( subWinRight, "\t[%d]=%2x [%d]=%2x\n", 1, pkg.data[0], 2, pkg.data[1] );
		wprintw( subWinRight, "\t[%d]=%2x [%d]=%2x\n", 3, pkg.data[2], 2, pkg.data[3] );
		wprintw( subWinRight, "\t[%d]=%2x [%d]=%2x\n", 5, pkg.data[4], 2, pkg.data[5] );
		wprintw( subWinRight, "\t[%d]=%2x [%d]=%2x\n\n", 7, pkg.data[6], 2, pkg.data[7] );


    wrefresh(subWinRight);

    sem_post(&plotting);
		id++;
  }

  pthread_exit(NULL);

}

static void showWinText(WINDOW *win, int lines, int cols, char *str)
{
  sem_wait(&plotting); // <----------
  wmove(win, lines, cols);
  wprintw(win, "\n");
  wmove(win, lines, cols);
  wprintw(win, "%s", str);
  wrefresh(win);
  sem_post(&plotting); // ---------->

  return;
}

void clearLine(WINDOW *win, int lines, int cols)
{
  wmove(win, lines, cols);
  wprintw(win, "\n");
  wmove(win, lines, cols);

  return;
}


static void printLeftText(void)
{
	sem_wait(&plotting);

  wmove(subWinLeft2, 0, 0);
  wprintw(subWinLeft2, "(0) Exit\n\n");
  wprintw(subWinLeft2, "(1) Set the number of CAN packages to send.\n\n");
  wprintw(subWinLeft2, "(2) Send CAN packages.\n\n");
  wprintw(subWinLeft2, "(3) Set Baud rate.\n\n");
	wprintw(subWinLeft2, "(4) Clear the Right side window.\n\n");
	wprintw(subWinLeft2, "(5) Clear the Left side window.\n");

  baseLine = 12;
  wmove(subWinLeft2, baseLine+0, 0);
  wprintw(subWinLeft2, "Please input: ");

  wrefresh(subWinLeft2);

	sem_post(&plotting);
  return;
}

void* scanStatus(void *ptr)
{
	while( running ) {
		sem_wait(&plotting);

		werase(subWinLeft1);
		wmove(subWinLeft1, 0, 0);
		wprintw(subWinLeft1, "Number of CAN packages to send: %d\n", pkgNum);
		wprintw(subWinLeft1, "(Set the number to 0 will send CAN packages continually.)\n\n");
		wprintw(subWinLeft1, "Baud rate: %d\n", baud);
		wprintw(subWinLeft1, "Package Length: %d\n", pkgLength);

		wrefresh(subWinLeft1);
		sem_post(&plotting);

		usleep(1000);
	}
	
	pthread_exit(NULL);
}
